"use strict";

let json_source = "https://prevision-meteo.ch/services/json/";
let mois = ["Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Aout", "Septembre", "Octobre", "Novembre", "Décembre"];
let orient = ["Nord", "Nord Est", "Est", "Sud Est", "Sud", "Sud Ouest", "Ouest", "Nord Ouest"];
let ville_pre = ["nancy", "paris", "marseille", "lyon", "mont-de-marsan", "troyes"];
let json_util, ville, Newville, datej, datej_edit, enterheur, heur, letimgorient, jourchoisis, test, chaud, affchaud, froid, afffroid;

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//défini l'orientation du tableau orient a utiliser selon la variable d'orientation du vent du json
function letdescorient(x) {
  if (x=="N") {
    return orient[0];
  }
  if (x=="NE") {
    return orient[1];
  }
  if (x=="E") {
    return orient[2];
  }
  if (x=="SE") {
    return orient[3];
  }
  if (x=="S") {
    return orient[4];
  }
  if (x=="SO") {
    return orient[5];
  }
  if (x=="O") {
    return orient[6];
  }
  if (x=="NO") {
    return orient[7];
  }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//function qui ressort le texte jour plus froid
function fonctionfroid(data) {
  froid = data['fcst_day_0']['tmin'];
  afffroid = "aujourd'hui";
  for (var i = 1; i <= 4; i++) {
    if (froid > data['fcst_day_'+i]['tmin']) {
      froid = data['fcst_day_'+i]['tmin'];
      afffroid = data['fcst_day_'+i]['day_long'];
    }
  }
  return "jour le plus froid : "+ afffroid + " "+froid+"°C"
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//function qui ressort le texte jour plus chaud
function fonctionchaud(data) {
  chaud = data['fcst_day_0']['tmax'];
  affchaud = "aujourd'hui";
  for (var i = 1; i <= 4; i++) {
    if (chaud < data['fcst_day_'+i]['tmax']) {
      chaud = data['fcst_day_'+i]['tmax'];
      affchaud = data['fcst_day_'+i]['day_long'];
    }
  }
  return "jour le plus chaud : "+ affchaud + " "+chaud+"°C"
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//function de mise page des élément d'erreur
function rooterror() {
  document.getElementById("enter-ville-edit").style.border = "solid 1px #FF6F6F";
  document.getElementById("error-message").style.display = "block";
  document.getElementById("error-message").innerHTML = `<span class="surligne">`+ville+`</span> n'est pas valide`;
  document.getElementById("error-message-bis").style.display = "block";
  document.getElementById("error-message-bis").innerHTML = `<span class="surligne">`+ville+`</span> n'est pas valide`;

  //remettre la ville précédente dans la variable ville
  ville = document.getElementById('localisation').innerHTML.toLowerCase();

  console.log("message d'erreur mis en place");
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//mise en place des élément des prochain jours
function rootglobal(data, jourchoisis) {

  //supprimer les message d'erreur
  document.getElementById("enter-ville-edit").style.border = "none";
  document.getElementById("error-message").style.display = "none";
  document.getElementById("error-message").innerHTML = `<span class="surligne">ville</span> n'est pas correcte`;
  document.getElementById("error-message-bis").style.display = "none";
  document.getElementById("error-message-bis").innerHTML = `<span class="surligne">ville</span> n'est pas correcte`;
  document.getElementById("titre").innerHTML = "Météo MMI ● "+data['city_info']['name'];
  document.getElementById("text-froid").innerHTML = fonctionfroid(data);
  document.getElementById("text-chaud").innerHTML = fonctionchaud(data);

  //boucle pour chaque jour de 1 a 4
  for (let i = 1; i <= 4; i++) {
    document.getElementById("icon-j"+i).innerHTML = `<img class="icon-secondary" src="`+`images/icon/`+data['fcst_day_'+i]['condition_key']+`.svg`+`" alt="icon `+data['fcst_day_'+i]['condition']+`">`;
    document.getElementById("jour-j"+i).innerHTML = data['fcst_day_'+i]['day_short'];
    document.getElementById("temp-min-j"+i).innerHTML = data['fcst_day_'+i]['tmin']+"°C";
    document.getElementById("temp-max-j"+i).innerHTML = data['fcst_day_'+i]['tmax']+"°C";
    document.getElementById("tooltip_condition_j"+i).innerHTML = data['fcst_day_'+i]['condition'];
  }

  console.log("élément des prochain jour mis jour");
  declencheur("primary", jourchoisis);
  console.log("élement global mis a jour");
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// mise en place des information primary
function rootprimary(data, lejour) {

  //si le jour n'est pas défini recupérer celui en place
  if (lejour==undefined) {
    lejour =document.getElementById('jour-stock').innerHTML;
  }

  //recupération de la valeur de l'heur affiché et mise en forme
  enterheur = document.getElementById('horloge-base').innerHTML;
  heur = enterheur+"00";

  //recupération du jour activé
  jourchoisis = document.getElementById('jour-stock').innerHTML;

  //définir le format de la date pour l'affichage
  datej_edit = data['fcst_day_'+lejour]['date'].split('.');
  datej = datej_edit[0]+" "+mois[datej_edit[1]-1]+" "+datej_edit[2];

  //création du code de l'orientation du vent
  letimgorient =`<img src="images/boussole/`+data['fcst_day_'+lejour]['hourly_data'][heur]['WNDDIRCARD10']+`.svg" alt="flèche `+letdescorient(data['fcst_day_'+lejour]['hourly_data'][heur]['WNDDIRCARD10'])+`">`;

  //définir le format de la ville pour l'affichage
  let viewville = data['city_info']['name'];
  viewville = viewville.replace(/\-/g," ");

  //mettre les element
  document.getElementById("zone-img").innerHTML = `<img class="primary-img" src="images/illustration/`+data['fcst_day_'+lejour]['hourly_data'][heur]['CONDITION_KEY']+`.jpg" alt="image de `+data['fcst_day_'+lejour]['hourly_data'][heur]['CONDITION']+`">`;
  document.getElementById("jour-sem-primary").innerHTML = data['fcst_day_'+lejour]['day_long'];
  document.getElementById("date-primary").innerHTML = datej;
  document.getElementById("localisation").innerHTML = viewville;
  document.getElementById("city").innerHTML = data['city_info']['country'];
  document.getElementById("div-icon-primary").innerHTML = `<img id="icon-primary" src="`+`images/icon/`+data['fcst_day_'+lejour]['hourly_data'][heur]['CONDITION_KEY']+`.svg`+`" alt="icon `+data['fcst_day_'+lejour]['hourly_data'][heur]['CONDITION']+`">`;
  document.getElementById("degre-primary").innerHTML = data['fcst_day_'+lejour]['hourly_data'][heur]['TMP2m']+"°C";
  document.getElementById("situation-primary").innerHTML = data['fcst_day_'+lejour]['hourly_data'][heur]['CONDITION'];
  document.getElementById("temp").innerHTML = data['fcst_day_'+lejour]['tmin']+"°C / "+data['fcst_day_'+lejour]['tmax']+"°C";
  document.getElementById("humi").innerHTML = data['fcst_day_'+lejour]['hourly_data'][heur]['RH2m']+"%  ";
  document.getElementById("imgorient").innerHTML = letimgorient;
  document.getElementById("descorient").innerHTML = letdescorient(data['fcst_day_'+lejour]['hourly_data'][heur]['WNDDIRCARD10']);
  document.getElementById("d-vent").innerHTML = data['fcst_day_'+lejour]['hourly_data'][heur]['WNDSPD10m']+" km/h";

  console.log("élément primary mis a jour");
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//changer d'heur manuellement pour les information affiché dans primary
function changerheur(heur) {

  //boucle pour remettre tout les boutons d'heur en format de base (pour enlever le précédent)
  for (var i = 0; i <= 23; i++) {
    document.getElementById('h'+i).style.backgroundColor = "";
    document.getElementById('h'+i).style.color = "";
  }

  // mettre le le bouton de l'heur selectionner en surligne et affiché la bonne heur
  document.getElementById(heur.id).style.backgroundColor = "#1100FF";
  document.getElementById(heur.id).style.color = "white";
  document.getElementById('horloge-base').innerHTML = heur.innerHTML+"H";

  console.log("l'heur utilisé est "+heur.value);

  //mettre en palce les élement dans primary
  declencheur("primary", jourchoisis, heur.value)
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// changer le jour des infromation affiché dans primary
function changerjour(jourchoisis) {

  //recupérer la valeur du jour actuelle dans test
  test = document.getElementById('jour-stock').innerHTML;

  //si le jour choisis correspond au jour actuelle remettre le jour 0
  if (test==jourchoisis) {
    document.getElementById("j"+jourchoisis).style.backgroundColor = "";
    jourchoisis = "0";
  }

  //sinon mettre le jour choisis
  else {

    //boucle qui enlève le style selectionné des jours
    for (var i = 1; i <= 4; i++) {
      document.getElementById("j"+i).style.backgroundColor = "";
    }

    //mettre le style selectionné(couleur de font bleu) au jour selectionné
    document.getElementById("j"+jourchoisis).style.backgroundColor = "#00A4FF";
  }
  console.log("jour "+jourchoisis+" est utilisé");

  //mettre en place les élément primary
  declencheur("primary", jourchoisis);
  document.getElementById('jour-stock').innerHTML = jourchoisis;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//fonction lancé depuis les radio qui change la ville et execute la mise en place des élément
function changerville(ville_choisis) {

  //recupérer la valeur de la ville choisis
  ville = ville_choisis.value;

  console.log("la ville "+ville+" est utilisé");

  //mettre en place les information global
  declencheur("global", jourchoisis);
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//fonction lancé depuis le bouton associé a l'input texte pour mettre une ville personnalisé
function changervilleecrit() {

  //récupération de la valeur de l'input texte et mise en form
  Newville = document.getElementById('enter-ville-edit');
  ville = Newville.value;

  //si l'input text est vide ne rien faire et remettre la ville actuelle dans la variable ville
  if (ville=="") {
    ville = document.getElementById('localisation').innerHTML.toLowerCase();
  }

  //sinon changer la ville avec celle de l'input
  else {

    //définir me format de la variable ville pour le json
    ville = ville.toLowerCase();
    ville = ville.replace(/ /g,"-");
    ville = ville.replace(new RegExp(/[àáâãäå]/g),"a");
    ville = ville.replace(new RegExp(/æ/g),"ae");
    ville = ville.replace(new RegExp(/ç/g),"c");
    ville = ville.replace(new RegExp(/[èéêë]/g),"e");
    ville = ville.replace(new RegExp(/[ìíîï]/g),"i");
    ville = ville.replace(new RegExp(/ñ/g),"n");
    ville = ville.replace(new RegExp(/[òóôõö]/g),"o");
    ville = ville.replace(new RegExp(/œ/g),"oe");
    ville = ville.replace(new RegExp(/[ùúûü]/g),"u");
    ville = ville.replace(new RegExp(/[ýÿ]/g),"y");
    ville = ville.replace(new RegExp(/\W/g),"");

    //vider le contenu de l'input text
    document.getElementById('enter-ville-edit').value = "";

    //deselectionner l'input radio
    for (let i = 0; i < allElems.length; i++) {
      if (allElems[i].type == 'radio' && allElems[i].checked) {
        allElems[i].checked = false;
      }
    }

    //vérifier si l'input text executer correspond a une des préselection et la coché si oui
    for (var i = 0; i < ville_pre.length; i++) {
      if (ville==ville_pre[i]) {
        document.getElementById('ville-'+ville_pre[i]).checked = true;
      }
    }

    console.log("la ville "+ ville +"est entré");

    //mettre les information global en place
    declencheur("global");
  }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//choisir une ville aléatoirement
function randomville() {
  //requette du json
  fetch("./data/villes.json")
    .then(response => response.json())
    .then(( data_alea) => {

      //prendre un nombre aléatoire parmit le nombre possibilité du json villes
      let alea = Math.floor(Math.random() * (Object.keys(data_alea).length - 0)) + 0
      console.log("tirage au sort sur la ville n°"+alea);

      //récupéré une ville en fonction du nombre aléatoire
      ville = data_alea[alea]['url'];
      console.log("qui correspond à: "+ville);

      //deselectionner l'input radio
      for (let i = 0; i < allElems.length; i++) {
        if (allElems[i].type == 'radio' && allElems[i].checked) {
          allElems[i].checked = false;
        }
      }

      //vérifier si l'input text executer correspond a une des préselection et la coché si oui
      for (var i = 0; i < ville_pre.length; i++) {
        if (ville==ville_pre[i]) {
          document.getElementById('ville-'+ville_pre[i]).checked = true;
        }
      }

      console.log("la ville "+ ville +"est entré");

      //mettre les information global en place
      declencheur("global");
    });
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//fonction de déclanchement qui récupère le json a utilisé et qui réagis a 3 etat "root" "primary" "global"
function declencheur(etat, jourchoisis) {

  //défini le json a utiliser selon la ville
  json_util = json_source + ville;

  //requette du json
  fetch(json_util)
    .then(response => response.json())
    .then((data) => {


      //tester si la json est correct au cas ou la ville choisis n'est pas correct
      if (data['errors']==undefined) {

        //tester si on est en etat global pour mettre en place tout les élement
        if (etat=="global") {

          rootglobal(data, jourchoisis)
        }

        //tester si on est en etat primary pour mettre en place les élément primary
        if (etat=="primary") {
        rootprimary(data, jourchoisis)
        }

        //tester si on est en etat root pour installer l'heur actuelle et lancé les élément global
        if (etat=="root") {

          //définir l'heur en fonction des current_condition du json
          heur =  data['current_condition']['hour'];

          //formalisé l'heur récupéré
          if (heur.charAt(0)==0) {
            heur = heur.charAt(1);
          }
          else {
            heur = heur.charAt(0)+heur.charAt(1);
          }


          //boucle pour remettre tout les boutons d'heur en format de base (pour enlever le précédent)
          for (var i = 0; i <= 23; i++) {
            document.getElementById('h'+i).style.backgroundColor = "";
            document.getElementById('h'+i).style.color = "";
          }

          //mettre en palce l'heur utilisé
          document.getElementById('horloge-base').innerHTML = heur+"H";
          document.getElementById('h'+heur).style.backgroundColor = "#1100FF";
          document.getElementById('h'+heur).style.color = "white";

          //mettre en place les élément global
          rootglobal(data)
        }
      }

      //si la json est incorrect lancer la fonction de root d'erreur
      else {
        rooterror()
      }

    });
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//quand l'input text est selectionner forcer le vu du menu ville
function forcer_vision() {
  document.getElementById("menu-ville-id").style.display = "grid";


}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//quand l'input text n'est plus selectionner arreter de forcer le vu du menu ville
function cancel_forcage() {
  document.getElementById("menu-ville-id").style.display = "";
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// rooting de base
let allElems = document.getElementsByTagName('input');
for (let i = 0; i < allElems.length; i++) {
  if (allElems[i].type == 'radio' && allElems[i].checked) {
    ville = allElems[i].value;
  }
}

//si il n'y a pas de ville définir nancy
if (ville==undefined) {
  ville = "nancy";
  document.getElementById('ville-nancy').checked = true;
}


declencheur("root");
